# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

import platform
from performance.services.cpu.access_linux import AccessLinux
from performance.performance_exceptions import PerformanceException


class AccessProvider(object):
    """ Provides access to services per OS
    """

    @staticmethod
    def get_cpu_access():
        """ Returns an implementation of CPU access class according to the OS
        """
        system_type = platform.system()
        if system_type.lower() == "linux":
            return AccessLinux()
        else:
            raise PerformanceException("No CPU access support for %s" %
                                       system_type)
