# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: December 26, 2017

from abc import ABCMeta

from performance.common.units_measure import UnitsMeasure
from performance.common.analyzer_value_type import AnalyzerValueType
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analyzers_groups import AnalyzersGroups
from performance.entities.analyzers_names_map \
    import AnalyzersNamesDescriptionMap as NamesMap
from performance.common.gui_components import GUIComponents
from performance.services.analysis.analyzers.layer_1.abc_analyzer \
    import ABCAnalyzer


class RXBandWidth(ABCAnalyzer):
    """ Abstract RX bandwidth, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(RXBandWidth, self).__init__()
        self.gui_component = GUIComponents.SPEEDOMETER
        self.units_measure = UnitsMeasure.GPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.RX_BW
        self.group = AnalyzersGroups.BW
        self.description = NamesMap().get_description(self.name)


class TXBandWidth(ABCAnalyzer):
    """ Abstract TX bandwidth, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(TXBandWidth, self).__init__()
        self.gui_component = GUIComponents.SPEEDOMETER
        self.units_measure = UnitsMeasure.GPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.TX_BW
        self.group = AnalyzersGroups.BW
        self.description = NamesMap().get_description(self.name)
