# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 07, 2018

from abc import ABCMeta

from performance.common.units_measure import UnitsMeasure
from performance.common.analyzer_value_type import AnalyzerValueType
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analyzers_groups import AnalyzersGroups
from performance.entities.analyzers_names_map \
    import AnalyzersNamesDescriptionMap as NamesMap
from performance.common.gui_components import GUIComponents
from performance.services.analysis.analyzers.layer_1.abc_analyzer \
    import ABCAnalyzer


class RXOptimalPacketRateBN(ABCAnalyzer):
    """ Abstract RX optimal theoretical packet rate bottleneck,
        all the specific analyzers will be derived from this class.
    """

    def __init__(self):
        super(RXOptimalPacketRateBN, self).__init__()
        self.gui_component = GUIComponents.CARD
        self.units_measure = UnitsMeasure.MPPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.RX_OPTIMAL_PACKET_RATE_BOTTLENECK
        self.group = AnalyzersGroups.ESWITCH
        self.description = NamesMap().get_description(self.name)


class TXOptimalPacketRateBN(ABCAnalyzer):
    """ Abstract TX optimal theoretical packet rate bottleneck,
        all the specific analyzers will be derived from this class.
    """

    def __init__(self):
        super(TXOptimalPacketRateBN, self).__init__()
        self.gui_component = GUIComponents.CARD
        self.units_measure = UnitsMeasure.MPPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.TX_OPTIMAL_PACKET_RATE_BOTTLENECK
        self.group = AnalyzersGroups.ESWITCH
        self.description = NamesMap().get_description(self.name)
