# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 03, 2017

from abc import ABCMeta

from performance.common.units_measure import UnitsMeasure
from performance.common.analyzer_value_type import AnalyzerValueType
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analyzers_groups import AnalyzersGroups
from performance.entities.analyzers_names_map \
    import AnalyzersNamesDescriptionMap as NamesMap
from performance.common.gui_components import GUIComponents
from performance.services.analysis.analyzers.layer_1.abc_analyzer \
    import ABCAnalyzer


class PCILatencyAvg(ABCAnalyzer):
    """ Abstract PCI latency average, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCILatencyAvg, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.AVG
        self.name = AnalyzersNames.PCI_AVG_LATENCY
        self.group = AnalyzersGroups.PCI_LATENCY
        self.description = NamesMap().get_description(self.name)


class PCILatencyMin(ABCAnalyzer):
    """ Abstract PCI latency minimum, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCILatencyMin, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.MIN
        self.name = AnalyzersNames.PCI_MIN_LATENCY
        self.group = AnalyzersGroups.PCI_LATENCY
        self.description = NamesMap().get_description(self.name)


class PCILatencyMax(ABCAnalyzer):
    """ Abstract PCI latency maximum, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCILatencyMax, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.MAX
        self.name = AnalyzersNames.PCI_MAX_LATENCY
        self.group = AnalyzersGroups.PCI_LATENCY
        self.description = NamesMap().get_description(self.name)
