# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from abc import ABCMeta

from performance.common.units_measure import UnitsMeasure
from performance.common.analyzer_value_type import AnalyzerValueType
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analyzers_groups import AnalyzersGroups
from performance.common.counters_names import CountersNames
from performance.entities.analyzers_names_map \
    import AnalyzersNamesDescriptionMap as NamesMap
from performance.common.gui_components import GUIComponents
from performance.services.analysis.analyzers.layer_1.abc_analyzer \
    import ABCAnalyzer


class PCIOutboundUsedBW(ABCAnalyzer):
    """ Abstract PCI outbound used band width, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCIOutboundUsedBW, self).__init__()
        self.gui_component = GUIComponents.SPEEDOMETER
        self.units_measure = UnitsMeasure.GPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.PCI_OUTBOUND_USED_BW
        self.group = AnalyzersGroups.PCI_BW
        self.description = NamesMap().get_description(self.name)
        self._add_required_counter(CountersNames.PXDP_TX_128B_DATA)


class PCIOutboundAvailableBW(ABCAnalyzer):
    """ Abstract PCI outbound available band width, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCIOutboundAvailableBW, self).__init__()
        self.gui_component = GUIComponents.SPEEDOMETER
        self.units_measure = UnitsMeasure.GPS
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.PCI_OUTBOUND_AVAILABLE_BW
        self.group = AnalyzersGroups.PCI_BW
        self.description = NamesMap().get_description(self.name)
        self._add_required_counter(CountersNames.PXDP_RX_128B_TOTAL)


class PCIOutboundUtilizationBW(ABCAnalyzer):
    """ Abstract PCI outbound used/available utilization band width,
        all the specific analyzers will be derived from this class.
    """

    def __init__(self):
        super(PCIOutboundUtilizationBW, self).__init__()
        self.gui_component = GUIComponents.SPEEDOMETER
        self.units_measure = UnitsMeasure.PERCENT
        self.value_type = AnalyzerValueType.ABSOLUTE
        self.name = AnalyzersNames.PCI_OUTBOUND_BW
        self.group = AnalyzersGroups.PCI_BW
        self.description = NamesMap().get_description(self.name)
        self._add_required_analyzer(AnalyzersNames.PCI_OUTBOUND_USED_BW)
        self._add_required_analyzer(AnalyzersNames.PCI_OUTBOUND_AVAILABLE_BW)
