# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Jan, 2020


from abc import ABCMeta

from performance.common.units_measure import UnitsMeasure
from performance.common.analyzer_value_type import AnalyzerValueType
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analyzers_groups import AnalyzersGroups
from performance.entities.analyzers_names_map \
    import AnalyzersNamesDescriptionMap as NamesMap
from performance.common.gui_components import GUIComponents
from performance.services.analysis.analyzers.layer_1.abc_analyzer \
    import ABCAnalyzer


class PCIPXTToARMLatencyAvg(ABCAnalyzer):
    """ Abstract PCI PXT to ARM latency average, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCIPXTToARMLatencyAvg, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.AVG
        self.name = AnalyzersNames.PCI_PXT_TO_ARM_LATENCY_AVG
        self.group = AnalyzersGroups.PCI_LATENCY_TO_ARM
        self.description = NamesMap().get_description(self.name)


class PCIPXTToARMLatencyMin(ABCAnalyzer):
    """ Abstract PCI PXT to ARM latency minimum, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCIPXTToARMLatencyMin, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.MIN
        self.name = AnalyzersNames.PCI_PXT_TO_ARM_LATENCY_MIN
        self.group = AnalyzersGroups.PCI_LATENCY_TO_ARM
        self.description = NamesMap().get_description(self.name)


class PCIPXTToARMLatencyMax(ABCAnalyzer):
    """ Abstract PCI PXT to ARM latency maximum, all the specific analyzers
        will be derived from this class.
    """

    def __init__(self):
        super(PCIPXTToARMLatencyMax, self).__init__()
        self.gui_component = GUIComponents.ERROR_BAR_GRAPH
        self.units_measure = UnitsMeasure.NS
        self.value_type = AnalyzerValueType.MAX
        self.name = AnalyzersNames.PCI_PXT_TO_ARM_LATENCY_MAX
        self.group = AnalyzersGroups.PCI_LATENCY_TO_ARM
        self.description = NamesMap().get_description(self.name)
