# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.utilities.utils import Utils
from performance.common.analyzers_names import AnalyzersNames
from performance.services.analysis.analyzers.layer_2.hops_per_packet \
    import RXHopsPerPacket, TXHopsPerPacket


class CXFamilyRXHopsPerPacket(RXHopsPerPacket):
    """ ConnectX RX hops per packet analyzer.
    """

    def __init__(self):
        super(CXFamilyRXHopsPerPacket, self).__init__()

    def analyse(self, pipe_0_rate, pipe_1_rate):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.RX_PACKET_RATE) > 0:
            rx_steering_rate = g_c_b_n(pipe_0_rate) + g_c_b_n(pipe_1_rate)
            calculation = rx_steering_rate / g_a_b_n(AnalyzersNames.RX_PACKET_RATE)
            # Steering can't be less than one, so fixing it to 1 in this case:
            self.value = self.round_up_to_one(calculation)


class CXFamilyTXHopsPerPacket(TXHopsPerPacket):
    """ ConnectX TX hops per packet analyzer.
    """

    def __init__(self):
        super(CXFamilyTXHopsPerPacket, self).__init__()

    def analyse(self, pipe_0_rate=None, pipe_1_rate=None):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.TX_PACKET_RATE) > 0:
            if pipe_1_rate is None:
                tx_steering_rate = g_c_b_n(pipe_0_rate)
            else:
                tx_steering_rate = g_c_b_n(pipe_0_rate) + g_c_b_n(pipe_1_rate)
            calculation = tx_steering_rate / g_a_b_n(AnalyzersNames.TX_PACKET_RATE)
            # Steering can't be less than one, so fixing it to 1 in this case:
            self.value = self.round_up_to_one(calculation)
