# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.utilities.utils import Utils
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analysis_constants import AnalysisConstants as AC
from performance.services.analysis.analyzers.layer_2.optimal_hops_per_packet \
    import RXOptimalHopsPerPacket, TXOptimalHopsPerPacket


class CXFamilyRXOptimalHopsPerPacket(RXOptimalHopsPerPacket):
    """ ConnectX RX theoretical optimal hops per packet per pipe analyzer.
    """

    def __init__(self):
        super(CXFamilyRXOptimalHopsPerPacket, self).__init__()

    def analyse(self, pipe_0_rate, pipe_1_rate):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.RX_PACKET_RATE) > 0:
            rx_total_steering = g_c_b_n(pipe_0_rate) + g_c_b_n(pipe_1_rate)
            rx_packet_rate = g_a_b_n(AnalyzersNames.RX_PACKET_RATE)
            calculation = rx_total_steering / rx_packet_rate / AC.TWO_PIPE
            # Steering can't be less than one, so fixing it to 1 in this case:
            self.value = self.round_up_to_one(calculation)


class CXFamilyTXOptimalHopsPerPacket(TXOptimalHopsPerPacket):
    """ ConnectX TX theoretical optimal hops per packet per pipe analyzer.
    """

    def __init__(self):
        super(CXFamilyTXOptimalHopsPerPacket, self).__init__()

    def analyse(self, pipe_0_rate, pipe_1_rate):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.TX_PACKET_RATE) > 0:
            tx_total_steering = g_c_b_n(pipe_0_rate) + g_c_b_n(pipe_1_rate)
            tx_packet_rate = g_a_b_n(AnalyzersNames.TX_PACKET_RATE)
            calculation = tx_total_steering / tx_packet_rate / AC.TWO_PIPE
            # Steering can't be less than one, so fixing it to 1 in this case:
            self.value = self.round_up_to_one(calculation)
