# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.common.analyzers_names import AnalyzersNames
from performance.services.analysis.analyzers.layer_2.\
    optimal_packet_rate_bottleneck \
    import RXOptimalPacketRateBN, TXOptimalPacketRateBN


class CXFamilyRXOptimalPacketRateBN(RXOptimalPacketRateBN):
    """ ConnectX RX optimal theoretical packet rate bottleneck analyzer.
    """

    def __init__(self):
        super(CXFamilyRXOptimalPacketRateBN, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.RX_PACKET_RATE) > 0:
            calculation = (g_c_b_n(CountersNames.DEVICE_CLOCKS) /
                           g_a_b_n(AnalyzersNames.RX_OPTIMAL_HOPS))
            self.value = calculation


class CXFamilyTXOptimalPacketRateBN(TXOptimalPacketRateBN):
    """ ConnectX TX optimal theoretical packet rate bottleneck analyzer.
    """

    def __init__(self):
        super(CXFamilyTXOptimalPacketRateBN, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if (g_a_b_n(AnalyzersNames.TX_PACKET_RATE) > 0 and
           g_a_b_n(AnalyzersNames.TX_OPTIMAL_HOPS) > 0):
            calculation = (g_c_b_n(CountersNames.DEVICE_CLOCKS) /
                           g_a_b_n(AnalyzersNames.TX_OPTIMAL_HOPS))
            self.value = calculation
