# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.common.analyzers_names import AnalyzersNames
from performance.services.analysis.analyzers.layer_2.packet_rate_bottleneck \
    import RXPacketRateBN, TXPacketRateBN


class CXFamilyRXPacketRateBN(RXPacketRateBN):
    """ ConnectX RX packet rate bottleneck analyzer.
    """

    def __init__(self):
        super(CXFamilyRXPacketRateBN, self).__init__()

    def analyse(self, pipe_0_rate, pipe_1_rate):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.RX_PACKET_RATE) > 0 and \
           g_a_b_n(AnalyzersNames.RX_HOPS):
            if g_c_b_n(pipe_0_rate) > g_c_b_n(pipe_1_rate):
                steering_bn = g_c_b_n(pipe_0_rate)
            else:
                steering_bn = g_c_b_n(pipe_1_rate)
            bn_calculation = (steering_bn /
                              g_a_b_n(AnalyzersNames.RX_PACKET_RATE))
            calculation = (g_c_b_n(CountersNames.DEVICE_CLOCKS) /
                           bn_calculation)
            self.value = calculation


class CXFamilyTXPacketRateBN(TXPacketRateBN):
    """ ConnectX TX packet rate bottleneck analyzer.
    """

    def __init__(self):
        super(CXFamilyTXPacketRateBN, self).__init__()

    def analyse(self, pipe_0_rate=None, pipe_1_rate=None):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_a_b_n(AnalyzersNames.TX_PACKET_RATE) > 0 and \
           g_a_b_n(AnalyzersNames.RX_HOPS):
            if pipe_1_rate is not None:
                if g_c_b_n(pipe_0_rate) > g_c_b_n(pipe_1_rate):
                    steering_bn = g_c_b_n(pipe_0_rate)
                else:
                    steering_bn = g_c_b_n(pipe_1_rate)
            else:
                steering_bn = g_c_b_n(pipe_0_rate)
            bn_calculation = (steering_bn /
                              g_a_b_n(AnalyzersNames.TX_PACKET_RATE))
            calculation = (g_c_b_n(CountersNames.DEVICE_CLOCKS) /
                           bn_calculation)
            self.value = calculation
