# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.common.analysis_constants import AnalysisConstants as AC
from performance.services.analysis.analyzers.layer_2.pci_inbound \
    import PCIInboundAvailableBW, PCIInboundUsedBW


class CXFamilyPCIInboundAvailableBW(PCIInboundAvailableBW):
    """ ConnectX PCI inbound available bandwidth analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIInboundAvailableBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        calculation = \
            (g_c_b_n(CountersNames.PXDP_RX_128B_TOTAL) *
             AC.PCI_LINE * AC.BITS_IN_BYTE / float(AC.BITS_IN_GIGA))
        self.value = calculation


class CXFamilyPCIInboundUsedBW(PCIInboundUsedBW):
    """ ConnectX PCI inbound used bandwidth analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIInboundUsedBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        calculation = \
            (g_c_b_n(CountersNames.PXDP_RX_128B_DATA) *
             AC.PCI_LINE * AC.BITS_IN_BYTE / float(AC.BITS_IN_GIGA))
        self.value = calculation
