# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 03, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.pci_latency \
    import PCILatencyAvg, PCILatencyMin, PCILatencyMax


class CXFamilyPCILatencyAvg(PCILatencyAvg):
    """ ConnectX PCI latency average analyzer.
    """

    def __init__(self):
        super(CXFamilyPCILatencyAvg, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.PCI_LATENCY_LINK0_AVG).value


class CXFamilyPCILatencyMin(PCILatencyMin):
    """ ConnectX PCI latency minimum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCILatencyMin, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.PCI_LATENCY_LINK0_MIN).value


class CXFamilyPCILatencyMax(PCILatencyMax):
    """ ConnectX PCI latency maximum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCILatencyMax, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.PCI_LATENCY_LINK0_MAX).value
