# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Jan, 2020


from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.pci_pxt_to_arm_latency \
    import PCIPXTToARMLatencyAvg, PCIPXTToARMLatencyMin, \
    PCIPXTToARMLatencyMax


class CXFamilyPCIPXTToARMLatencyAvg(PCIPXTToARMLatencyAvg):
    """ ConnectX PCI PXT to ARM latency average analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToARMLatencyAvg, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_ARM_LATENCY_AVG).value


class CXFamilyPCIPXTToARMLatencyMin(PCIPXTToARMLatencyMin):
    """ ConnectX PCI PXT to ARM latency minimum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToARMLatencyMin, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_ARM_LATENCY_MIN).value


class CXFamilyPCIPXTToARMLatencyMax(PCIPXTToARMLatencyMax):
    """ ConnectX PCI PXT to ARM latency maximum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToARMLatencyMax, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_ARM_LATENCY_MAX).value
