# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 03, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.pci_pxt_to_pxdp_latency \
    import PCIPXTToPXDPLatencyAvg, PCIPXTToPXDPLatencyMin, \
    PCIPXTToPXDPLatencyMax


class CXFamilyPCIPXTToPXDPLatencyAvg(PCIPXTToPXDPLatencyAvg):
    """ ConnectX PCI PXT to PXDP latency average analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToPXDPLatencyAvg, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_AVG).value


class CXFamilyPCIPXTToPXDPLatencyMin(PCIPXTToPXDPLatencyMin):
    """ ConnectX PCI PXT to PXDP latency minimum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToPXDPLatencyMin, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_MIN).value


class CXFamilyPCIPXTToPXDPLatencyMax(PCIPXTToPXDPLatencyMax):
    """ ConnectX PCI PXT to PXDP latency maximum analyzer.
    """

    def __init__(self):
        super(CXFamilyPCIPXTToPXDPLatencyMax, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_MAX).value
