# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 09, 2017

from performance.common.counters_names import CountersNames
from performance.common.analyzers_names import AnalyzersNames
from performance.services.analysis.analyzers.layer_2.\
    rx_indirect_mem_key_rate import RXInderectMemKeyRate


class CXFamilyRXInderectMemKeyRate(RXInderectMemKeyRate):
    """ ConnectX RX indirect memory key rate analyzer.
    """

    def __init__(self):
        super(CXFamilyRXInderectMemKeyRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        g_a_b_n = self.get_analyzer_by_name
        if g_c_b_n(CountersNames.TPT_INDIRECT_MEM_KEY) > 0:
            calculation = (g_c_b_n(CountersNames.TPT_INDIRECT_MEM_KEY) /
                           g_a_b_n(AnalyzersNames.RX_PACKET_RATE))
            self.value = calculation
