# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_3.\
    cx_family_optimal_hops_per_packet import CXFamilyRXOptimalHopsPerPacket


class CX4FamilyRXOptimalHopsPerPacket(CXFamilyRXOptimalHopsPerPacket):
    """ ConnectX-4/4 Lx RX theoretical optimal hops per packet analyzer.
    """

    def __init__(self):
        super(CX4FamilyRXOptimalHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX4FamilyRXOptimalHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            RXT_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            RXT_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)
