# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: December 26, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.packet_rate \
    import RXPacketRate, TXPacketRate


class CX4FamilyRXPacketRate(RXPacketRate):
    """ ConnectX-4/4 LX RX packet rate analyzer.
    """

    def __init__(self):
        super(CX4FamilyRXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        calculation = \
            (g_c_b_n(CountersNames.RXT_CTRL_PERF_SLICE_LOAD_SLOW) +
             g_c_b_n(CountersNames.RXT_CTRL_PERF_SLICE_LOAD_FAST) -
             g_c_b_n(CountersNames.RXB_LRO_FIFO_PERF_COUNT2))
        self.value = calculation.value


class CX4FamilyTXPacketRate(TXPacketRate):
    """ ConnectX-4/4 LX TX packet rate analyzer.
    """

    def __init__(self):
        super(CX4FamilyTXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = \
            g_c_b_n(CountersNames.SXW_PACKET_SEND_SXW2SXP_GO_VID).value
