# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_3. \
    cx_family_optimal_hops_per_packet \
    import CXFamilyRXOptimalHopsPerPacket, CXFamilyTXOptimalHopsPerPacket


class CX5FamilyRXOptimalHopsPerPacket(CXFamilyRXOptimalHopsPerPacket):
    """ ConnectX-5/5 EX RX theoretical optimal hops per packet analyzer.
    """

    def __init__(self):
        super(CX5FamilyRXOptimalHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX5FamilyRXOptimalHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            RXPS_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            RXPS_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)


class CX5FamilyTXOptimalHopsPerPacket(CXFamilyTXOptimalHopsPerPacket):
    """ ConnectX-5/5 EX TX theoretical optimal hops per packet analyzer.
    """

    def __init__(self):
        super(CX5FamilyTXOptimalHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX5FamilyTXOptimalHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            SXP_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            SXP_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)
