# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: December 26, 2017

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.packet_rate \
    import RXPacketRate, TXPacketRate


class CX5FamilyRXPacketRate(RXPacketRate):
    """ ConnectX-5/5 EX RX Packet Rate analyzer.
    """

    def __init__(self):
        super(CX5FamilyRXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.RXB_BW_COUNT_PERF_COUNT_0_2).value


class CX5FamilyTXPacketRate(TXPacketRate):
    """ ConnectX-5/5 EX TX Packet Rate analyzer.
    """

    def __init__(self):
        super(CX5FamilyTXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.SXP_BW_COUNT_PERF_COUNT_0_2).value
