# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.analyzers_names import AnalyzersNames
from performance.common.analysis_constants import AnalysisConstants as AC
from performance.services.analysis.analyzers.layer_2.pci_inbound \
    import PCIInboundUtilizationBW


class CX5FamilyPCIInboundUtilizationBW(PCIInboundUtilizationBW):
    """ ConnectX-5/5 EX PCI inbound used/available
        utilization band width analyzer.
    """

    def __init__(self):
        super(CX5FamilyPCIInboundUtilizationBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.get_analyzer_by_name
        calculation = \
            ((g_c_b_n(AnalyzersNames.PCI_INBOUND_USED_BW) /
              g_c_b_n(AnalyzersNames.PCI_INBOUND_AVAILABLE_BW)) *
             float(AC.TO_PERCENT))
        self.value = calculation
