# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January 04, 2017

from performance.common.counters_names import CountersNames
from performance.common.analyzers_names import AnalyzersNames
from performance.common.analysis_constants import AnalysisConstants as AC
from performance.services.analysis.analyzers.layer_2.pci_outbound \
    import PCIOutboundUsedBW, PCIOutboundAvailableBW, PCIOutboundUtilizationBW


class CX5FamilyPCIOutboundUsedBW(PCIOutboundUsedBW):
    """ ConnectX-5/5 EX PCI outbound used bandwidth analyzer.
    """

    def __init__(self):
        super(CX5FamilyPCIOutboundUsedBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        calculation = \
            (g_c_b_n(CountersNames.PXDP_TX_128B_DATA) *
             AC.PCI_LINE * AC.BITS_IN_BYTE / float(AC.BITS_IN_GIGA))
        self.value = calculation


class CX5FamilyPCIOutboundAvailableBW(PCIOutboundAvailableBW):
    """ ConnectX-5/5 EX PCI outbound available bandwidth analyzer.
    """

    def __init__(self):
        super(CX5FamilyPCIOutboundAvailableBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        calculation = \
            (g_c_b_n(CountersNames.PXDP_RX_128B_TOTAL) *
             AC.PCI_LINE * AC.BITS_IN_BYTE / float(AC.BITS_IN_GIGA))
        self.value = calculation


class CX5FamilyPCIOutboundUtilizationBW(PCIOutboundUtilizationBW):
    """ ConnectX-5/5 EX PCI outbound used/available
        utilization band width analyzer.
    """

    def __init__(self):
        super(CX5FamilyPCIOutboundUtilizationBW, self).__init__()

    def analyse(self):
        g_c_b_n = self.get_analyzer_by_name
        calculation = \
            ((g_c_b_n(AnalyzersNames.PCI_OUTBOUND_USED_BW) /
              g_c_b_n(AnalyzersNames.PCI_OUTBOUND_AVAILABLE_BW)) *
             float(AC.TO_PERCENT))
        self.value = calculation
