# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Nov 14, 2019

from performance.common.counters_names import CountersNames
from performance.common.analyzers_names import AnalyzersNames
from performance.services.analysis.analyzers.layer_2.hops_per_packet \
    import TXHopsPerPacket
from performance.services.analysis.analyzers.layer_3.\
    cx_family_hops_per_packet \
    import CXFamilyRXHopsPerPacket, CXFamilyTXHopsPerPacket


class CX6DXFamilyRXHopsPerPacket(CXFamilyRXHopsPerPacket):
    """ ConnectX-6 DX RX hops per packet analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyRXHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX6DXFamilyRXHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            PSA_RX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            PSA_RX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)


class CX6DXFamilyTXHopsPerPacket(CXFamilyTXHopsPerPacket):
    """ ConnectX-6 DX TX hops per packet analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyTXHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX6DXFamilyTXHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            PSA_TX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            PSA_TX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)
