# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Nov 14, 2019

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_3. \
    cx_family_optimal_hops_per_packet \
    import CXFamilyRXOptimalHopsPerPacket, CXFamilyTXOptimalHopsPerPacket


class CX6DXFamilyRXOptimalHopsPerPacket(CXFamilyRXOptimalHopsPerPacket):
    """ ConnectX-6 DX RX theoretical optimal hops per packet analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyRXOptimalHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX6DXFamilyRXOptimalHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            PSA_RX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            PSA_RX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)


class CX6DXFamilyTXOptimalHopsPerPacket(CXFamilyTXOptimalHopsPerPacket):
    """ ConnectX-6 DX TX theoretical optimal hops per packet analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyTXOptimalHopsPerPacket, self).__init__()

    def analyse(self):
        super(CX6DXFamilyTXOptimalHopsPerPacket, self).analyse(
            pipe_0_rate=CountersNames.
            PSA_TX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE,
            pipe_1_rate=CountersNames.
            PSA_TX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE)
