# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Nov 14, 2019

from performance.common.counters_names import CountersNames
from performance.services.analysis.analyzers.layer_2.packet_rate \
    import RXPacketRate, TXPacketRate


class CX6DXFamilyRXPacketRate(RXPacketRate):
    """ ConnectX-6 DX RX Packet Rate analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyRXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.PTB_PORT_IF_PACKETS_ALL_PORTS).value


class CX6DXFamilyTXPacketRate(TXPacketRate):
    """ ConnectX-6 DX TX Packet Rate analyzer.
    """

    def __init__(self):
        super(CX6DXFamilyTXPacketRate, self).__init__()

    def analyse(self):
        g_c_b_n = self.data.get_object_by_name
        self.value = g_c_b_n(CountersNames.SXP_BW_COUNT_PERF_COUNT_0_2).value
