# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

import commands
from performance.services.logger import PerformanceLog


class LinuxCommand(object):
    """ Describes an interface for executing Linux commands.
    """
    def __init__(self):
        self.log = PerformanceLog().get_log()

    def run_command(self, cmd, prnt=False):
        """ Run command
        """
        if prnt:
            self.log.info("Run cmd: %s" % cmd)
        else:
            self.log.debug("Run cmd: %s" % cmd)
        (rc, output) = commands.getstatusoutput(cmd)
        return (rc, output)

    def run_command_debug_when_fail(self, cmd,
                                    debug_message=False, prnt=False):
        """ Run command and print debug message when failed
        """
        if prnt:
            self.log.debug("Run cmd: %s" % cmd)
        (rc, output) = commands.getstatusoutput(cmd)
        if rc:
            self.log.debug("Failed to run cmd: %s" % cmd)
            if debug_message:
                self.log.debug("%s" % (debug_message))
        return (rc, output)

    def run_command_warn_when_fail(self, cmd,
                                   warning_message=False, prnt=False):
        """ Run command and print warning message when failed
        """
        if prnt:
            self.log.info("Run cmd: %s" % cmd)
        else:
            self.log.debug("Run cmd: %s" % cmd)
        (rc, output) = commands.getstatusoutput(cmd)
        if rc:
            self.log.warning("Failed to run cmd: %s" % cmd)
            if warning_message:
                self.log.warning("%s" % (warning_message))
        return (rc, output)
