# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

import abc
from vendor import Vendor
from architecture import Architecture
from performance.performance_exceptions import PerformanceException


class Access(object):
    """ Describes an abstract CPU access class
    """
    __metaclass__ = abc.ABCMeta

    def __init__(self):
        self.total_cores = 0
        self.physical_cores = 0
        self.sockets = 0
        self.sockets_cores = {}
        self.sibling_cores = {}
        self.physical_cores = {}
        self.offline_cores = {}
        self.all_cores = []
        self.model = None
        self.vendor = Vendor.UNKNOWN
        self.architecture = Architecture.UNKNOWN
        self.actual_frequency = None
        self.max_frequency = None

    @abc.abstractmethod
    def collect_info(self, node_info):
        """ Collects CPU information from the system and
            updates the class fields
        """
        raise PerformanceException(
            "Abatract CPU access dosesn't implement collect_info method")
