# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

from vendor import Vendor
from vendor_constants import VendorConstants


class Architecture(object):
    """ Describes a CPU architecture
    """
    SANDY_BRIDGE = "Sandy Bridge"
    IVY_BRIDGE = "Ivy Bridge"
    HASWELL = "Haswell"
    BROADWELL = "Broadwell"
    SKYLAKE = "Skylake"
    AARCH64 = "AArch64"
    PPC64LE = "ppc64le"
    PPC64 = "ppc64"
    X86_64 = "x86_64"
    UNKNOWN = "NA"
    HASWELL_UARCH = [HASWELL, BROADWELL]

    MODEL_TO_ARCH = {
                      Vendor.INTEL: {
                        VendorConstants.INTEL_FAMILY: {
                          VendorConstants.INTEL_SNB_MODEL: SANDY_BRIDGE,
                          VendorConstants.INTEL_IVB_MODEL: IVY_BRIDGE,
                          VendorConstants.INTEL_HSW_MODEL: HASWELL,
                          VendorConstants.INTEL_BDWL_MODEL: BROADWELL,
                          VendorConstants.INTEL_SKL_MODEL: SKYLAKE
                        }
                      },
                      Vendor.IBM: {
                        VendorConstants.IBM_PPC64LE_MODEL: PPC64LE
                      },
                      Vendor.ARM: {
                        VendorConstants.ARM_AARCH64_MODEL: AARCH64
                      }
                    }
