# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: September 14, 2017

from one_of_filter import OneOfFilter
from performance.common.filter_mode import FilterMode


class Filter(object):
    """ Filtering service for the module,
        will include different kind of filters for counters and units.
    """

    def __init__(self, data):
        super(Filter, self).__init__()
        self.__filters = list()
        self.__initialize_filters(data)

    def __initialize_filters(self, data):
        """ Initialize filter classes.
        """
        self.__filters.append(OneOfFilter(data=data))

    def filter(self):
        """ Run all filters.
        """
        mode = FilterMode.DONT_RUN
        for filter in self.__filters:
            mode = filter.filter()
        return mode
