# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd.  Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: January, 10 2018

from performance.common.filter_mode import FilterMode
from performance.common.counters_names import CountersNames
from performance.common.counter_keys import CounterKeys
from performance.api.schema_keys import SchemaKeys
from base_filter import BaseFilter


class OneOfFilter(BaseFilter):
    """ Filter counters based on the given data.
    """

    def __init__(self, data=None):
        super(OneOfFilter, self).__init__(data=data)
        self._counters.append(CountersNames.DEVICE_CLOCKS_WRAPAROUND)
        self._counters.append(CountersNames.PXDP_RX_128B_DATA)
        self._counters.append(CountersNames.PXDP_RX_128B_TOTAL)
        self._counters.append(CountersNames.PXDP_TX_128B_DATA)
        self._counters.append(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_AVG)
        self._counters.append(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_MIN)
        self._counters.append(CountersNames.PXT_TO_PXDP_LATENCY_LINK0_MAX)
        self._counters.append(CountersNames.PCI_LATENCY_LINK0_AVG)
        self._counters.append(CountersNames.PCI_LATENCY_LINK0_MIN)
        self._counters.append(CountersNames.PCI_LATENCY_LINK0_MAX)
        self._counters.append(CountersNames.PXT_TO_ARM_LATENCY_AVG)
        self._counters.append(CountersNames.PXT_TO_ARM_LATENCY_MIN)
        self._counters.append(CountersNames.PXT_TO_ARM_LATENCY_MAX)
        self._counters.append(CountersNames.SXP_BW_COUNT_PERF_COUNT_0_1)
        self._counters.append(CountersNames.SXP_BW_COUNT_PERF_COUNT_0_2)
        self._counters.append(CountersNames.SXP_BW_COUNT_PERF_COUNT_1_1)
        self._counters.append(CountersNames.SXP_BW_COUNT_PERF_COUNT_1_2)
        self._counters.append(CountersNames.RXB_BW_COUNT_PERF_COUNT_0_1)
        self._counters.append(CountersNames.RXB_BW_COUNT_PERF_COUNT_0_2)
        self._counters.append(CountersNames.RXB_BW_COUNT_PERF_COUNT_1_1)
        self._counters.append(CountersNames.RXB_BW_COUNT_PERF_COUNT_1_2)
        self._counters.append(CountersNames.PTB_PORT_IF_48B_PORT_0)
        self._counters.append(CountersNames.PTB_PORT_IF_48B_PORT_1)
        self._counters.append(CountersNames.PTB_PORT_IF_PACKETS_ALL_PORTS)
        self._counters.append(CountersNames.SXW_PACKET_SEND_SXW2SXP_GO_VID)

    def filter(self):
        """ Filter unneeded for presentation counter.
        """
        self._data[SchemaKeys.COUNTERS] = filter(
            lambda counter: counter[SchemaKeys.COUNTER][CounterKeys.NAME]
            not in self._counters, self._data[SchemaKeys.COUNTERS])
        return FilterMode.RUN
