# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017

import time

from connectx_device_mcra import ConnectXDeviceMCRA
from connectx4_mcra import ConnectX4MCRACountres
from connectx4lx_mcra import ConnectX4LXMCRACountres
from performance.common.device_family import DeviceFamily
from performance.performance_exceptions import PerformanceException
from performance.services.analysis.analyzers.layer_3.cx_family_pci_latency \
    import CXFamilyPCILatencyAvg, CXFamilyPCILatencyMin, CXFamilyPCILatencyMax
from performance.services.analysis.analyzers.layer_3. \
    cx_family_pci_pxt_to_pxdp_latency import \
    CXFamilyPCIPXTToPXDPLatencyAvg, \
    CXFamilyPCIPXTToPXDPLatencyMin, \
    CXFamilyPCIPXTToPXDPLatencyMax
from performance.services.analysis.analyzers.layer_4. \
    cx4_family_packet_rate import \
    CX4FamilyRXPacketRate, \
    CX4FamilyTXPacketRate
from performance.services.analysis.analyzers.layer_4. \
    cx4_family_optimal_hops_per_packet import \
    CX4FamilyRXOptimalHopsPerPacket
from performance.services.analysis.analyzers.layer_3. \
    cx_family_optimal_packet_rate_bottleneck import \
    CXFamilyRXOptimalPacketRateBN
from performance.services.analysis.analyzers.layer_4. \
    cx4_family_hops_per_packet import \
    CX4FamilyRXHopsPerPacket, \
    CX4FamilyTXHopsPerPacket
from performance.services.analysis.analyzers.layer_4. \
    cx4_family_packet_rate_bottleneck import \
    CX4FamilyRXPacketRateBN, \
    CX4FamilyTXPacketRateBN
from performance.services.analysis.analyzers.layer_3. \
    cx_family_rx_indirect_mem_key_rate import \
    CXFamilyRXInderectMemKeyRate


class ConnectX4DeviceMCRA(ConnectXDeviceMCRA):
    """ Represents MCRA ConnectX4 device.
    """
    def __init__(self, mstdev, device_id):
        super(ConnectX4DeviceMCRA, self).__init__(mstdev,
                                                  DeviceFamily.CONNECTX4,
                                                  device_id)

        if self.device_id > 0:
            if ConnectX4MCRACountres.is_device_id_ok(self.device_id):
                self.mcra = ConnectX4MCRACountres()
            elif ConnectX4LXMCRACountres.is_device_id_ok(self.device_id):
                self.mcra = ConnectX4LXMCRACountres()

        if self.mcra is None:
            error_message = self.device_error_message.format(
                device_id=self.device_id)
            self.set_error(error_message)

        self._initialize_analyzers()

    def _initialize_analyzers(self):
        """ Initialize ConnectX-4/4 Lx specific analyzer.
        """
        super(ConnectX4DeviceMCRA, self)._initialize_analyzers()
        self._analyzers += [
            CXFamilyPCILatencyAvg(),
            CXFamilyPCILatencyMin(),
            CXFamilyPCILatencyMax(),
            CXFamilyPCIPXTToPXDPLatencyAvg(),
            CXFamilyPCIPXTToPXDPLatencyMin(),
            CXFamilyPCIPXTToPXDPLatencyMax(),
            CX4FamilyRXPacketRate(),
            CX4FamilyTXPacketRate(),
            CX4FamilyRXOptimalHopsPerPacket(),
            CXFamilyRXOptimalPacketRateBN(),
            CX4FamilyRXHopsPerPacket(),
            CX4FamilyRXPacketRateBN(),
            CX4FamilyTXHopsPerPacket(),
            CX4FamilyTXPacketRateBN(),
            CXFamilyRXInderectMemKeyRate()
            ]
