# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Yossi Kendel
# @date: Sep 11, 2019

import time

from connectx_device_mcra import ConnectXDeviceMCRA
from connectx6dx_mcra import ConnectX6DXMCRACountres
from performance.common.device_family import DeviceFamily
from performance.performance_exceptions import PerformanceException
from performance.services.analysis.analyzers.layer_3.cx_family_pci_latency \
    import CXFamilyPCILatencyAvg, CXFamilyPCILatencyMin, CXFamilyPCILatencyMax
from performance.services.analysis.analyzers.layer_3. \
    cx_family_pci_pxt_to_pxdp_latency import \
    CXFamilyPCIPXTToPXDPLatencyAvg, \
    CXFamilyPCIPXTToPXDPLatencyMin, \
    CXFamilyPCIPXTToPXDPLatencyMax
from performance.services.analysis.analyzers.layer_4. \
    cx6dx_family_packet_rate import \
    CX6DXFamilyRXPacketRate, \
    CX6DXFamilyTXPacketRate
from performance.services.analysis.analyzers.layer_4. \
    cx6dx_family_bw import \
    CX6DXFamilyRXBandWidth, \
    CX6DXFamilyTXBandWidth
from performance.services.analysis.analyzers.layer_4. \
    cx5_family_pci_outbound import \
    CX5FamilyPCIOutboundUsedBW, \
    CX5FamilyPCIOutboundAvailableBW, \
    CX5FamilyPCIOutboundUtilizationBW
from performance.services.analysis.analyzers.layer_4. \
    cx5_family_pci_inbound import \
    CX5FamilyPCIInboundUtilizationBW
from performance.services.analysis.analyzers.layer_4. \
    cx6dx_family_optimal_hops_per_packet import \
    CX6DXFamilyRXOptimalHopsPerPacket, \
    CX6DXFamilyTXOptimalHopsPerPacket
from performance.services.analysis.analyzers.layer_3. \
    cx_family_optimal_packet_rate_bottleneck import \
    CXFamilyRXOptimalPacketRateBN, \
    CXFamilyTXOptimalPacketRateBN
from performance.services.analysis.analyzers.layer_4. \
    cx6dx_family_hops_per_packet import \
    CX6DXFamilyRXHopsPerPacket, \
    CX6DXFamilyTXHopsPerPacket
from performance.services.analysis.analyzers.layer_4. \
    cx6dx_family_packet_rate_bottleneck import \
    CX6DXFamilyRXPacketRateBN, \
    CX6DXFamilyTXPacketRateBN
from performance.services.analysis.analyzers.layer_3. \
    cx_family_rx_indirect_mem_key_rate import \
    CXFamilyRXInderectMemKeyRate


class ConnectX6DXDeviceMCRA(ConnectXDeviceMCRA):
    """ Represents ConnectX-6 Dx device definitions.
    """
    def __init__(self, mstdev, device_id):
        super(ConnectX6DXDeviceMCRA, self).__init__(mstdev,
                                                  DeviceFamily.CONNECTX6DX,
                                                  device_id)

        if self.device_id > 0:
            if ConnectX6DXMCRACountres.is_device_id_ok(self.device_id):
                self.mcra = ConnectX6DXMCRACountres(device=self.mf)

        if self.mcra is None:
            error_message = self.device_error_message.format(
                device_id=self.device_id)
            self.set_error(error_message)

        self._initialize_analyzers()

    def _initialize_analyzers(self):
        """ Initialize ConnectX-6 Dx specific analyzer.
        """
        super(ConnectX6DXDeviceMCRA, self)._initialize_analyzers()
        self._analyzers += [
            CXFamilyPCILatencyAvg(),
            CXFamilyPCILatencyMin(),
            CXFamilyPCILatencyMax(),
            CXFamilyPCIPXTToPXDPLatencyAvg(),
            CXFamilyPCIPXTToPXDPLatencyMin(),
            CXFamilyPCIPXTToPXDPLatencyMax(),
            CX6DXFamilyRXPacketRate(),
            CX6DXFamilyTXPacketRate(),
            CX6DXFamilyRXBandWidth(),
            CX6DXFamilyTXBandWidth(),
            CX6DXFamilyRXOptimalHopsPerPacket(),
            CXFamilyRXOptimalPacketRateBN(),
            CX6DXFamilyRXHopsPerPacket(),
            CX6DXFamilyRXPacketRateBN(),
            CX6DXFamilyTXHopsPerPacket(),
            CX6DXFamilyTXPacketRateBN(),
            CX6DXFamilyTXOptimalHopsPerPacket(),
            CXFamilyTXOptimalPacketRateBN(),
            CXFamilyRXInderectMemKeyRate(),
            CX5FamilyPCIOutboundUsedBW(),
            CX5FamilyPCIOutboundAvailableBW(),
            CX5FamilyPCIOutboundUtilizationBW(),
            # The analyzers below commented out, due to possible bug in
            # the required counter for them in the chip.
            CX5FamilyPCIInboundUtilizationBW()
            ]

        ## See comment above, this is to remove the analyzer from base class.
        #self._analyzers = filter(
        #    lambda analyzer: (analyzer.__class__.__name__ !=
        #                      CXFamilyPCIInboundAvailableBW.__name__),
        #    self._analyzers)
