# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: August 23, 2017

import os

from performance.performance_exceptions import PerformanceException


class Recording(object):
    """ Recording service of the plug-in.
    """
    def __init__(self, record_log_path):
        super(Recording, self).__init__()
        self.record_log_path = record_log_path
        self.__validate_record_parameters()

    def __validate_record_parameters(self):
        """ Validation of the recording service parameters.
        """
        try:
            if not os.path.isfile(self.record_log_path):
                open(self.record_log_path, 'w').close()
        except OSError as error:
            PerformanceException(error.message)

    def record(self, data):
        """ Save the object the log file.
        """
        try:
            with open(self.record_log_path, 'a+') as log:
                log.write(data + os.linesep)
        except OSError as error:
            PerformanceException(error.message)
