# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: September 07, 2017

from abc import ABCMeta, abstractmethod


class ABCSupportCondition(object):
    """ Abstract support condition class.
    """
    __metaclass__ = ABCMeta

    def __init__(self, support_parameters=None):
        super(ABCSupportCondition, self).__init__()
        self._support_parameters = support_parameters
        self._condition = None

    @abstractmethod
    def check_support(self):
        """ Check the support, based on a condition.
        """
        pass
