# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd.  Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: May 28, 2018

from abc_support_condition import ABCSupportCondition
from performance.performance_exceptions import NotSupportedException
from performance.services.mcra.regaccess import RegAccess
from performance.common.support_condition_keys \
    import SupportServiceKeys as SSK


class SecureFWCondition(ABCSupportCondition):
    """ Check if the FW secured.
    """

    def __init__(self, support_parameters=None):
        super(SecureFWCondition, self).__init__(
            support_parameters=support_parameters)
        self._condition = "secure FW"

    def check_support(self):
        pci_address = self._support_parameters[SSK.PCI_DEVICE]
        secure_fw = RegAccess(pci_device=pci_address).getSecureFWStatus()
        if secure_fw:
            raise NotSupportedException(condition=self._condition)
