# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: May 28, 2018

from secure_fw_condition import SecureFWCondition


class Support(object):
    """ Support service for the module,
        will include different kind of conditions
        that states wether the plugin is supported or not.
    """

    def __init__(self, support_parameters):
        super(Support, self).__init__()
        self.__conditions = list()
        self.__initialize_conditions(support_parameters)

    def __initialize_conditions(self, support_parameters):
        """ Initialize conditions classes.
        """
        self.__conditions.append(SecureFWCondition(
            support_parameters=support_parameters))

    def run_inspection(self):
        """ Run all conditions.
        """
        for contidtion in self.__conditions:
            contidtion.check_support()
