# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017

from worker import Worker
from performance.entities.data import Data
from performance.services.communication.alert import Alert
from performance.services.communication.alert_code import AlertCode
from performance.services.communication.cmd import Cmd
from performance.services.communication.op_code import OpCode
from performance.services.mcra.connectx4_device_mcra import ConnectX4DeviceMCRA
from performance.services.mcra.connectx5_device_mcra import ConnectX5DeviceMCRA
from performance.services.mcra.bluefield_device_mcra import BlueFieldDeviceMCRA
from performance.services.mcra.connectx6_device_mcra import ConnectX6DeviceMCRA
from performance.services.mcra.connectx6dx_device_mcra import ConnectX6DXDeviceMCRA
from performance.common.device_family import DeviceFamily
from performance.performance_exceptions import PerformanceException


class WorkerService(Worker):
    """
    """
    def __init__(self, device, device_id, is_external=False):
        super(WorkerService, self).__init__(WorkerService.__name__,
                                            is_external=is_external)

        self.nic = None
        try:
            family = DeviceFamily.get_family(device_id)
            if family == DeviceFamily.CONNECTX4:
                self.nic = ConnectX4DeviceMCRA(device, device_id)
            elif family == DeviceFamily.CONNECTX5:
                self.nic = ConnectX5DeviceMCRA(device, device_id)
            elif family == DeviceFamily.BLUEFIELD:
                self.nic = BlueFieldDeviceMCRA(device, device_id)
            elif family == DeviceFamily.CONNECTX6:
                self.nic = ConnectX6DeviceMCRA(device, device_id)
            elif family == DeviceFamily.CONNECTX6DX:
                self.nic = ConnectX6DXDeviceMCRA(device, device_id)
            elif family == DeviceFamily.BLUEFIELD2:
                self.nic = BlueField2DeviceMCRA(device, device_id)
        except PerformanceException as error:
            raise PerformanceException(str(error))

        if self.nic:
            if self.nic.get_error():
                self.set_error(self.nic.get_error())
        if not self.nic or self.get_error():
            self.set_error("Error: Can't init nic for device %s" % device)

    def can_work(self):
        return super(WorkerService, self).can_work()

    def main_func(self):
        data = self.nic.get_next_data()
        if data:
            self.parent_worker.Q.put(Data(data))
            self.iteration += 1

    def main_loop(self):
        exit = False

        self.nic.take_snapshot()
        while not exit:
            if self.Q.empty():
                self.main_func()
                exit = self.check_iterations()
            else:
                obj = self.Q.get_nowait()
                if type(obj).__name__ == Cmd.__name__:
                    cmd = obj
                    if cmd.op_code == OpCode.Stop:
                        exit = True
        self.nic.restore_from_snapshot()
        if self.parent_worker:
            self.parent_worker.Q.put(Alert(AlertCode.FINISHED))
