# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Simon Raviv
# @date: December 21, 2017

from performance.performance_exceptions import OneOfException


NONE = "N/A"


class Utils(object):
    """ Common utilities for the plug-in.
    """

    @staticmethod
    def one_of(one, all):
        """ Check if one is in all list.
        """
        if one not in all:
            raise OneOfException(one, all)

    @staticmethod
    def get_all(cls):
        """ Returns list of class variables.
        """
        result = list()
        for key, value in vars(cls).iteritems():
            if not (callable(getattr(cls, key)) or key.startswith("__")):
                if value != NONE:
                    result.append(value)
        return result

    @staticmethod
    def get_object_by_name(data, name):
        """ Returns class instance by name.
        """
        for obj in data:
            if obj.name == name:
                return obj
        return None
