#!/bin/bash

os_type=`uname -s`
g_remove_pkg_cmd="rpm -e --allmatches --nodeps"
g_is_installed_cmd="rpm -q"

g_neohost_gui_uninstall="uninstall-neohost-gui.sh"
g_neohost_dir="/opt/neohost"
g_frontend_dir="${g_neohost_dir}/frontend"
g_neohost_gui_dir="${g_frontend_dir}/neohost_gui"

neohost_pkgs=( "neohost-backend" "neohost-sdk" )
if [[ ${os_type} != FreeBSD ]]; then
    if [[ `uname -v` == *Ubuntu* ]] || [[ `cat /etc/issue | head -1` == *Debian* ]]; then
        g_remove_pkg_cmd="dpkg --purge"
        g_is_installed_cmd="dpkg -s"
    fi
fi
function pkg_is_installed () {
    package_name=$1
    ${g_is_installed_cmd} ${package_name} &> /dev/null
    return $?
}

function check_pkgs_present() {
    rc=0
    while [ "$1" ]; do
        package_name=$1
        pkg_is_installed ${package_name}; RC=$?
        if [ "${RC}" == "0" ]; then
            echo "-W- Failed to remove the package \"${package_name}\", try to remove it manually."
            rc=1
        fi
        shift
    done
    return $rc
}

function cleanup_neohost_gui() {
    if [ -d ${g_frontend_dir} ]; then
        echo "-I- Removing NeoHost GUI ....."
        if [ -x ${g_neohost_gui_dir}/${g_neohost_gui_uninstall} ]; then
            ${g_neohost_gui_dir}/${g_neohost_gui_uninstall}
        else
            rm -rf ${g_frontend_dir}
        fi
    fi
}

function uninstall_neohost() {
    if [[ "${os_type}" == "FreeBSD" ]]; then
        echo "-I- Removing NeoHost packages ....."
        post_uninstall_script=${g_neohost_dir}/backend/post-uninstall.sh
        sdk_dir=${g_neohost_dir}/sdk
        if [ -d ${sdk_dir} ]; then
            rm -rf ${sdk_dir}
        fi
        if [ -f ${post_uninstall_script} ]; then
            ${post_uninstall_script} 0
        fi
        rc=$?
        if [ "$rc" != "0" ]; then
            echo "-E- An error accured while trying to remove $src. Solve this problem manually and re-run the script"
            exit $rc
        fi
    else
        cleanup_neohost_gui
        echo "-I- Removing NeoHost packages ....."
        for pkg in ${neohost_pkgs[*]}
        do
            pkg_is_installed ${pkg}; RC=$?
            if [ "${RC}" == "0" ]; then
                echo "-I- Removing ${pkg} ..."
                ${g_remove_pkg_cmd} ${pkg}
            fi
            shift
        done

        check_pkgs_present ${neohost_pkgs[*]}
    fi
}

uninstall_neohost
