# SPDX-License-Identifier: GPL-2.0-only
# Copyright (C) 2019 Mellanox Technologies. All Rights Reserved.
#

Name: rshim
Version: 2.0.6
Release: 1.ga97dc5d%{?dist}
Summary: User-space driver for Mellanox BlueField SoC

License: GPLv2

URL: https://github.com/mellanox/rshim-user-space
Source0: https://github.com/mellanox/rshim-user-space/archive/%{name}-%{version}.tar.gz

BuildRequires: gcc, autoconf, automake, pkgconfig, make
BuildRequires: pkgconfig(libpci), pkgconfig(libusb-1.0), pkgconfig(fuse)

%if 0%{?rhel} >= 8 || 0%{?fedora} > 0
Requires: kernel-modules-extra
%endif

%global with_systemd %(if (test -d "%{_unitdir}" > /dev/null); then echo -n '1'; else echo -n '0'; fi)

%description
This is the user-space driver to access the BlueField SoC via the rshim
interface. It provides ways to push boot stream, debug the target or login
via the virtual console or network interface.

%prep
rm -fr %{name}-%{version}
mkdir %{name}-%{version}
tar -axf %{SOURCE0} -C %{name}-%{version} --strip-components 1
%setup -q -D -T

%build
./bootstrap.sh
%configure
%if %{?make_build:1}%{!?make_build:0}
%make_build
%else
make
%endif

%install
%undefine _missing_build_ids_terminate_build
%makeinstall -C src INSTALL_DIR="%{buildroot}%{_sbindir}"
%if "%{with_systemd}" == "1"
  %{__install} -d %{buildroot}%{_unitdir}
  %{__install} -m 0644 rshim.service %{buildroot}%{_unitdir}
%endif
%{__install} -d %{buildroot}%{_mandir}/man8
%{__install} -m 0644 man/rshim.8 %{buildroot}%{_mandir}/man8
%{__install} -m 0644 man/bfb-install.8 %{buildroot}%{_mandir}/man8
%{__install} -d %{buildroot}%{_sysconfdir}
%{__install} -m 0644 etc/rshim.conf %{buildroot}%{_sysconfdir}
%{__install} -m 0755 scripts/bfb-install %{buildroot}%{_sbindir}

%pre
%if "%{with_systemd}" == "1"
  if systemctl is-active --quiet rshim ; then
      systemctl stop rshim
  fi
%endif

%post
%if "%{with_systemd}" == "1"
  systemctl daemon-reload
  systemctl enable rshim
  systemctl start rshim
%endif

%preun
if [ "$1" = "0" ]; then
%if "%{with_systemd}" == "1"
  if systemctl is-active --quiet rshim ; then
      systemctl stop rshim
  fi
%else
  killall -9 rshim
%endif
fi

%files
%{!?_licensedir:%global license %%doc}
%license LICENSE
%defattr(-,root,root,-)
%doc README.md
%config(noreplace) %{_sysconfdir}/rshim.conf
%if "%{with_systemd}" == "1"
  %{_unitdir}/rshim.service
%endif
%{_sbindir}/rshim
%{_sbindir}/bfb-install
%{_mandir}/man8/rshim.8.gz
%{_mandir}/man8/bfb-install.8.gz

%changelog
* Wed May 12 2021 Liming Sun <limings@nvidia.com> - 2.0.6-1
- Disable the background timer if no rshim devices
- Setting default path for rshim config file

* Wed Mar 10 2021 Liming Sun <limings@nvidia.com> - 2.0.5-10
- PCIe hotplug support
- Reduce CPU utilization when there is no rshim device

* Wed Jan 27 2021 Liming Sun <limings@nvidia.com> - 2.0.5-9
- Fix potential tmfifo data loss
- Add workaround checking for Bluefield-2 REV-0
- Fix network traffic stop issue when Tx buffer full

* Fri Dec 11 2020 Liming Sun <limings@nvidia.com> - 2.0.5-8
- Don't allow any register access when DROP_MODE is set
- Avoid potential race in rshim_fifo_read

* Wed Dec 09 2020 Liming Sun <limings@nvidia.com> - 2.0.5-7
- Fix potential dead-lock when calling rshim_access_check
- Ignore rshim access checking when global drop mode is enabled
- Fix some secure boot related issue

* Wed Dec 02 2020 Liming Sun <limings@nvidia.com> - 2.0.5-6
- Add some default configuration in rshim.conf
- Change the debug level of Rshim byte access widget timeout
- Add bfb-install script

* Thu Oct 29 2020 Liming Sun <lsun@mellanox.com> - 2.0.5-5
- Check rshim accessibility when re-enabling it
- Enable console output during boot stream pushing
- Add some delay for the pcie_lf probe
- Auto-start rshim service after installation

* Fri Sep 25 2020 Liming Sun <lsun@mellanox.com> - 2.0.5-4
- Some robust fixes for USB rshim
- Fix a typo in pcie mmap

* Mon Aug 17 2020 Liming Sun <lsun@mellanox.com> - 2.0.5-3
- Fix several coverity warnings
- Add workaround to boot Viper rev A0 in LiveFish mode
- Display/configure OPN string for BlueField-2

* Fri Jul 24 2020 Liming Sun <lsun@mellanox.com> - 2.0.5-2
- Add configuration file support
- misc: Display device version / revision ID
- Add service file for FreeBSD

* Tue Jun 16 2020 Liming Sun <lsun@mellanox.com> - 2.0.5-1
- Improve response time to ctrl+c for boot stream
- Fix a rpmbuild issue when make_build is not defined
- Add DROP_MODE configuration in misc file
- Avoid reading the fifo if still booting
- Fix configure issue for FreeBSD 12.1-RELEASE
- Add domain id to the DEV_NAME in the misc file
- Fix the debian copyright format
- Enhance rshim_pcie_enable function

* Tue Apr 21 2020 Liming Sun <lsun@mellanox.com> - 2.0.4-1
- Update .spec file according to review comments
- Fix the 'KillMode' in rshim.service
- Support process termination by SIGTERM
- Fix some compiling warnings and configure issue for FreeBSD
- Fix a read()/write() issue in rshim_pcie.c caused by optimization

* Tue Apr 14 2020 Liming Sun <lsun@mellanox.com> - 2.0.3-1
- Enable pci device during probing
- Map the pci resource0 file instead of /dev/mem
- Add copyright header in bootstrap.sh
- Add 'Requires' tag check in the rpm .spec for kernel-modules-extra
- Fix the 'rshim --version' output

* Thu Apr 09 2020 Liming Sun <lsun@mellanox.com> - 2.0.2-1
- Remove unnecessary dependency in .spec and use make_build
- Add package build for debian/ubuntu
- Fix some format in the man page
- Add check for syslog headers

* Mon Mar 23 2020 Liming Sun <lsun@mellanox.com> - 2.0.1-1
- Rename bfrshim to rshim
- Remove rshim.spec since it's auto-generated from rshim.spec.in
- Fix some warnings reported by coverity
- Add file rhel/rshim.spec.in for fedora
- Move rshim to sbin and move man page to man8

* Fri Mar 13 2020 Liming Sun <lsun@mellanox.com> - 2.0-1
- Update the spec file according to fedora packaging-guidelines

* Mon Dec 16 2019 Liming Sun <lsun@mellanox.com>
- Initial packaging
