/*
 * Copyright (c) 2004-2021 Mellanox Technologies LTD. All rights reserved
 * Copyright (c) 2021-2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef CABLE_IBDM_ERRORS_H_
#define CABLE_IBDM_ERRORS_H_


enum CABLE_INFO_VS_STATUS {
    CABLEINFO_VS_STATUS_SUCCESS = 0x00,
    CABLEINFO_VS_STATUS_INVALID_PORT = 0x01,
    CABLEINFO_VS_STATUS_PORT_NOT_QSFP = 0x02,
    CABLEINFO_VS_STATUS_CABLE_NOT_CONNECTED = 0x03,
    CABLEINFO_VS_STATUS_NO_EEPROM = 0x0004,
    CABLEINFO_VS_STATUS_INVALID_PAGE_NUM = 0x05,
    CABLEINFO_VS_STATUS_INVALID_ADDR_OR_SIZE = 0x06,
    CABLEINFO_VS_STATUS_INVALID_SLAVE_ADDR = 0x07,
    CABLEINFO_VS_STATUS_BAD_QSFP_CABLE = 0x08
};

enum EYE_OPEN_INFO_AUTONEGO_VALUE {
    AUTONEGO_VALUE_SUCCESS = 0x00,
    AUTONEGO_VALUE_NOT_QDR = 0x01,
    AUTONEGO_VALUE_IN_PROGRESS = 0x02,
    AUTONEGO_VALUE_LINK_DOWN = 0x03
};

#include <string>
using namespace std;

string ConvertAutonegValueToStr(u_int8_t autoneg_val);
string ConvertCableInfoVSStatusToStr(u_int8_t vs_status);

#endif
