#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetApplicationFileData(CommandSdk):
    """
    This class to get file data
    """

    def __init__(self):
        """
        Constructor for GetApplicationFileData
        """
        super(GetApplicationFileData, self).__init__()
        self.__fileType = None
        self.__startLine = None
        self.__numOfLines = None

    def addOptions(self):
        """
        add options
        """
        super(GetApplicationFileData, self).addOptions()
        self._cmdParser.add_option("--file-type", dest="fileType",
                                   help=NC.HELP_FILE_TYPE,
                                   type="int",
                                   default=None)
        self._cmdParser.add_option("--num-of-lines", dest="numOfLines",
                                   help=NC.HELP_NUMBER_OF_LINES,
                                   type="int",
                                   default=NC.NUM_OF_LINES)
        self._cmdParser.add_option("--start-line", dest="startLine",
                                   help=NC.HELP_START_LINE,
                                   type="int",
                                   default=NC.START_LINE)

    def parseOptions(self):
        """
        parse options
        """
        super(GetApplicationFileData, self).parseOptions()
        self.__fileType = self._options.fileType
        self.__startLine = self._options.startLine
        self.__numOfLines = self._options.numOfLines

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetApplicationFileData, self).prepareRequest()
        accessDataModifierDict = {NC.PARAM_NUM_OF_LINES: self.__numOfLines,
                                  NC.PARAM_START_LINE: self.__startLine}
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_APPLICATION_FILE_DATA
        self.request[NC.ATTR_MODULE] = NC.MODULE_CORE
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_FILE_TYPE: self.__fileType,
                                        NC.PARAM_ACCESS_DATA_MODIFIER: accessDataModifierDict}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetApplicationFileData, self).validateOptions()
        if not self.__fileType:
            raise NeohostSdkException("-E- %s. %s" % (NC.MISSING_FILE_TYPE, NC.HELP_FILE_TYPE))


if __name__ == "__main__":
    rc = GetApplicationFileData.main()
    sys.exit(rc)
