#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetApplicationFileMetaData(CommandSdk):
    """
    This class to get file meta data
    """

    def __init__(self):
        """
        Constructor for GetApplicationFileMetaData
        """
        super(GetApplicationFileMetaData, self).__init__()
        self.__fileType = None

    def addOptions(self):
        """
        add options
        """
        super(GetApplicationFileMetaData, self).addOptions()
        self._cmdParser.add_option("--file-type", dest="fileType",
                                   help=NC.HELP_FILE_TYPE,
                                   type="int",
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetApplicationFileMetaData, self).parseOptions()
        self.__fileType = self._options.fileType

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetApplicationFileMetaData, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_APPLICATION_FILE_META_DATA
        self.request[NC.ATTR_MODULE] = NC.MODULE_CORE
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_FILE_TYPE: self.__fileType}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetApplicationFileMetaData, self).validateOptions()
        if not self.__fileType:
            raise NeohostSdkException("-E- %s. %s" % (NC.MISSING_FILE_TYPE, NC.HELP_FILE_TYPE))


if __name__ == "__main__":
    rc = GetApplicationFileMetaData.main()
    sys.exit(rc)
