#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
# local imports
import neohost_sdk_constants as NC
from neohost_dumps import NeohostDumps
from neohost_sdk_exception import NeohostSdkException


class GetDeviceCrDump(NeohostDumps):
    """
    This class to get device CR dump
    """

    def __init__(self):
        """
        Constructor for NeohostDumps
        """
        super(GetDeviceCrDump, self).__init__()
        self.__devUid = None
        self.__dumpCount = 1
        self.__dumpMode = NC.FAST_MODE

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceCrDump, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)
        self._cmdParser.add_option("--dump-count", dest="dumpCount",
                                   help=NC.HELP_DUMP_COUNT,
                                   type="int",
                                   default=1)
        self._cmdParser.add_option("--run-mode", dest="dumpMode",
                                   help=NC.HELP_CR_DUMP_RUN_MODE,
                                   choices=NC.NEOHOST_DUMP_MODES.keys(),
                                   default=NC.FAST_MODE)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceCrDump, self).parseOptions()
        self.__devUid = self._options.devUid
        self.__dumpCount = self._options.dumpCount
        self.__dumpMode =  NC.NEOHOST_DUMP_MODES[self._options.dumpMode]

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceCrDump, self).prepareRequest()
        self.request[NC.ATTR_PARAMS][NC.PARAM_DUMP_COUNT] = self.__dumpCount
        self.request[NC.ATTR_PARAMS][NC.PARAM_DEV_UID] = self.__devUid
        self.request[NC.ATTR_PARAMS][NC.PARAM_DUMP_MODE] = self.__dumpMode
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_CR_DUMP

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetDeviceCrDump, self).validateOptions()
        if self.__devUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)
        if self.__dumpCount > 5 or self.__dumpCount < 1:
            raise NeohostSdkException("-E- Wrong Dump Count:  %s" % NC.HELP_DUMP_COUNT)


if __name__ == "__main__":
    rc = GetDeviceCrDump.main()
    sys.exit(rc)
