#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
# local imports
import neohost_sdk_constants as NC
from neohost_dumps import NeohostDumps
from neohost_sdk_exception import NeohostSdkException


class GetDeviceFlashDump(NeohostDumps):
    """
    This class to get device flash dump
    """

    def __init__(self):
        """
        Constructor for GetDeviceFlashDump
        """
        super(GetDeviceFlashDump, self).__init__(timeout=1000)
        self.__devUid = None

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceFlashDump, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceFlashDump, self).parseOptions()
        self.__devUid = self._options.devUid

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceFlashDump, self).prepareRequest()
        self.request[NC.ATTR_PARAMS][NC.PARAM_DEV_UID] = self.__devUid
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_FLASH_DUMP

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetDeviceFlashDump, self).validateOptions()
        if self.__devUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)


if __name__ == "__main__":
    rc = GetDeviceFlashDump.main()
    sys.exit(rc)
