#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from neohost_config import NeohostConfig
import neohost_sdk_constants as NC


class GetDeviceNVConfig(NeohostConfig):
    """
    This class to get device non volatile configuration
    """

    def __init__(self):
        """
        Constructor for GetDeviceNVConfig
        """
        super(GetDeviceNVConfig, self).__init__()
        self.__configMode = None
        self.__configName = None
        self.__configModifier = None

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceNVConfig, self).addOptions()
        self._cmdParser.add_option("--config-mode", dest="configMode",
                                   help=NC.HELP_CONFIG_MODE,
                                   type="int",
                                   default=1)
        self._cmdParser.add_option("--config-name", dest="configName",
                                   help=NC.HELP_CONFIG_NAME,
                                   default=None)
        self._cmdParser.add_option("--config-modifier", dest="configModifier",
                                   help=NC.HELP_CONFIG_MODIFIER,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceNVConfig, self).parseOptions()
        self.__configMode = int(self._options.configMode)
        self.__configName = self._options.configName
        self.__configModifier = self._options.configModifier

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceNVConfig, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_NV_CONFIG
        self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_MODE] = self.__configMode
        if self.__configName:
            self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_NAME] = self.__configName
        if self.__configModifier:
            self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_MODIFIER] = self.__configModifier


if __name__ == "__main__":
    rc = GetDeviceNVConfig.main()
    sys.exit(rc)
