#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from neohost_config import NeohostConfig
import neohost_sdk_constants as NC


class GetDeviceNVConfigMetadata(NeohostConfig):
    """
    This class to get device non volatile configuration metadata
    """

    def __init__(self):
        """
        Constructor for GetDeviceNVConfigMetadata
        """
        super(GetDeviceNVConfigMetadata, self).__init__()
        self.__supportedParamsOnly = None
        self.__configName = None

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceNVConfigMetadata, self).addOptions()
        self._cmdParser.add_option("--supported-params-only", dest="supportedParamsOnly",
                                   help=NC.HELP_SUPPORTED_PARAMS_ONLY,
                                   action="store_true",
                                   default=None)
        self._cmdParser.add_option("--config-name", dest="configName",
                                   help=NC.HELP_CONFIG_NAME,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceNVConfigMetadata, self).parseOptions()
        self.__supportedParamsOnly = self._options.supportedParamsOnly
        self.__configName = self._options.configName

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceNVConfigMetadata, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_NV_CONFIG_META_DATA
        if self.__supportedParamsOnly:
            self.request[NC.ATTR_PARAMS][NC.PARAM_SUPPORTED_PARAMS_ONLY] = self.__supportedParamsOnly
        if self.__configName:
            self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_NAME] = self.__configName


if __name__ == "__main__":
    rc = GetDeviceNVConfigMetadata.main()
    sys.exit(rc)
