#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Weam Mikkawi   weammik@mellanox.com -- created: 2018/May

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetDeviceRoCEState(CommandSdk):
    """
    This class to get device RoCE Stete
    """

    def __init__(self):
        """
        Constructor for GetDeviceRoCEState
        """
        super(GetDeviceRoCEState, self).__init__()
        self.__devUid = None
        self.__interfaceUid = None

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceRoCEState, self).addOptions()
        self._cmdParser.add_option("--interface-uid", dest="interfaceUid",
                                   help=NC.HELP_INTERFACE_UID,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceRoCEState, self).parseOptions()
        self.__interfaceUid = self._options.interfaceUid

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceRoCEState, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_ROCE_STATE
        self.request[NC.ATTR_MODULE] = NC.MODULE_CONFIG_FLOWS
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_IFC_UID: self.__interfaceUid}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetDeviceRoCEState, self).validateOptions()
        if not self.__interfaceUid:
            raise NeohostSdkException("-E- %s" % NC.MISSING_IFC_UID)

if __name__ == "__main__":
    rc = GetDeviceRoCEState.main()
    sys.exit(rc)
