#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/June

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetDeviceThermalThresholds(CommandSdk):
    """
    This class to get device thermal thresholds
    """

    def __init__(self):
        """
        Constructor for GetDeviceThermalThresholds
        """
        super(GetDeviceThermalThresholds, self).__init__()
        self.__devUid = None

    def addOptions(self):
        """
        add options
        """
        super(GetDeviceThermalThresholds, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetDeviceThermalThresholds, self).parseOptions()
        self.__devUid = self._options.devUid

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetDeviceThermalThresholds, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_DEVICE_THERMAL_THRESHOLDS
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_FW
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DEV_UID: self.__devUid}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetDeviceThermalThresholds, self).validateOptions()
        if not self.__devUid:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)


if __name__ == "__main__":
    rc = GetDeviceThermalThresholds.main()
    sys.exit(rc)
