#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetInterfaceInfo(CommandSdk):
    """
    This class to get interface information
    """

    def addOptions(self):
        """
        add options
        """
        super(GetInterfaceInfo, self).addOptions()
        self._cmdParser.add_option("--interface-uid", dest="interfaceUid",
                                   help=NC.HELP_INTERFACE_UID,
                                   default=None)
        self._cmdParser.add_option("--attr-mask", dest="attrMask",
                                   help=NC.HELP_ATTR_MASK,
                                   type="int",
                                   default=0)

    def parseOptions(self):
        """
        parse options
        """
        # Handle a string attrMask
        super(GetInterfaceInfo, self).parseOptions()
        self.__interfaceUid = self._options.interfaceUid
        self.__attrMask = int(self._options.attrMask)

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetInterfaceInfo, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_INTERFACE_INFO
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_CORE
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_IFC_UID: self.__interfaceUid,
                                        NC.PARAM_ATTR_MASK: self.__attrMask}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetInterfaceInfo, self).validateOptions()
        if not self.__interfaceUid:
            raise NeohostSdkException("-E- %s" % NC.MISSING_IFC_UID)


if __name__ == "__main__":
    rc = GetInterfaceInfo.main()
    sys.exit(rc)
