#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class GetJobStatus(CommandSdk):
    """
    This class to get job status for a given tokenID
    """

    def addOptions(self):
        """
        add options
        """
        super(GetJobStatus, self).addOptions()
        self._cmdParser.add_option("--job-token-id", dest="jobTokenId",
                                   help=NC.HELP_JOB_TOKEN,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(GetJobStatus, self).parseOptions()
        self.__jobTokenId = self._options.jobTokenId

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetJobStatus, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_APP_JOB_STATUS
        self.request[NC.ATTR_MODULE] = NC.MODULE_CORE
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_JOB_TOKEN: self.__jobTokenId}

    def validateOptions(self):
        """
        Validate Options
        """
        super(GetJobStatus, self).validateOptions()
        if self.__jobTokenId == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_JOB_TOKEN)
        if self._execMode == NC.A_SYNCHRONOUS:
            raise NeohostSdkException("%s %s." % (NC.UNSUPPORTED_EXEC_MODE, NC.METHOD_GET_APP_JOB_STATUS))


if __name__ == "__main__":
    rc = GetJobStatus.main()
    sys.exit(rc)
